'''
Julie Luan
ACAD 191, Fall 2025
julielua@usc.edu
Homework 4
'''

from hero import Hero

# Display the menu
def printMenu():
    print("Choose an option:")
    print("1. Load Heroes")
    print("2. Print Hero Roster")
    print("3. Hero Fight!")
    print("4. Quit")

# Load heroes from a file and return a list of Hero objects
def loadHeroes(filename):
    heroes = []
    try:
        file = open(filename, 'r')  # Open the file
        lines = file.readlines()
        for line in lines:
            if line.strip():  # Skip empty lines
                hero = Hero(line)  # Create Hero object from line
                heroes.append(hero)
        file.close()  # Close the file
        print(f"{len(heroes)} heroes loaded")
    except FileNotFoundError:
        print("File not found. Please try again.")
    return heroes

# Print all heroes in the hero_list
def printRoster(hero_list):
    if not hero_list:
        print("No heroes loaded yet.")
        return
    print(f"The following {len(hero_list)} heroes are loaded...")
    print("********************************************")
    for hero in hero_list:
        print(hero)  # __str__ of Hero
        print("********************************************")

# Main program loop
def main():
    print("Welcome to the hero fighter!")
    print("---------------------------------------")

    heroes = []  # List to store loaded heroes

    while True:
        printMenu()
        choice = input("> ").strip()

        if choice == '1':
            filename = input("Enter file to load: ").strip()
            heroes = loadHeroes(filename)
            print("---------------------------------------")

        elif choice == '2':
            printRoster(heroes)
            print("---------------------------------------")

        elif choice == '3':
            print("Stay tuned for the fight of the century!")
            print("---------------------------------------")

        elif choice == '4':
            print("Goodbye!")
            break

        else:
            print("Invalid choice, please try again.")
            print("---------------------------------------")

# Run main only if this file is executed directly
if __name__ == "__main__":
    main()